<?php session_start(); ?>
<?php 
	include "database.php";
	if(!isset($_SESSION['admin_id'])){
		echo '<script> window.location.href = "login.php"; </script>';
		header("location:login.php"); exit();
	}
	
	$role = $_SESSION['role'];
	
	$user_id = $_SESSION['admin_id'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
   <?php include "includes/headerlinks.php";?>
   <link href="assets/plugins/Magnific-Popup-master/dist/magnific-popup.css" rel="stylesheet">
   <style>
	.canvasjs-chart-toolbar {
		display:none !important;
	}
	.card-subtitle {
		//color:white !important;
	}
   </style>
</head>

<body class="fix-header fix-sidebar card-no-border">
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <?php include "includes/loader.php";?>
    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Topbar header - style you can find in pages.scss -->
        <!-- ============================================================== -->
	<?php include "includes/header.php";?>
        <!-- ============================================================== -->
        <!-- End Topbar header -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Left Sidebar - style you can find in sidebar.scss  -->
        <!-- ============================================================== -->
		<?php include "includes/sidebar.php";?>
        <!-- ============================================================== -->
        <!-- End Left Sidebar - style you can find in sidebar.scss  -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Page wrapper  -->
        <!-- ============================================================== -->
		<div class="page-wrapper">
            <!-- ============================================================== -->
            <!-- Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <div class="row page-titles">
                <div class="col-md-5 align-self-center">
                    <h3 class="text-themecolor">Dashboard</h3>
                </div>
                <div class="col-md-7 align-self-center">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0)" style="color:#000 !important;">Home</a></li>
                         <li class="breadcrumb-item active">Dashboard</li>
                    </ol>
                </div>
            </div>
            <!-- ============================================================== -->
            <!-- End Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container-fluid">
			
			<?php if($role=='Super Admin'){?>
				<div class="row">
                    <div class="col-lg-4 col-md-12">
                        <!-- card -->
                        <div class="card card-inverse card-primary">
                            <div class="card-body">
                                <div class="d-flex">
                                    <div class="m-r-20 align-self-center">
                                        <h1 class="text-white"><i class="ti-pie-chart"></i></h1></div>
                                    <div>
                                        <h3 class="card-title">Overall Sales</h3>
                                        <h6 class="card-subtitle text-white"><?php echo date('M');?> <?php echo date('Y');?></h6> </div>
                                </div>
                                <div class="row">
                                    <div class="col-12 p-t-10 p-b-20 align-self-center">
                                        <h2 class="font-light text-white">
											$<?php 
												$result = mysqli_query($con, "SELECT SUM(total_price) as SUM from orders");
												$row = mysqli_fetch_array($result);
												$total = $row['SUM'];
												if($total>0){
													$total_f = number_format($total,2);
													echo preg_replace("/\.?0+$/", "", $total_f); 
												} else {
													echo '0';
												}
											?> 
										</h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- card -->
                    </div>
                    <div class="col-lg-4 col-md-12">
                        <div class="card card-inverse card-warning">
                            <div class="card-body">
                                <div class="d-flex">
                                    <div class="m-r-20 align-self-center">
                                        <h1 class="text-white"><i class="icon-cloud-download"></i></h1></div>
                                    <div>
                                        <h3 class="card-title">Today's Sales</h3>
                                        <h6 class="card-subtitle text-white"><?php echo date('M');?> <?php echo date('Y');?></h6> </div>
                                </div>
                                <div class="row">
                                    <div class="col-4 align-self-center">
                                        <h2 class="font-light text-white" style="display:inline-block !important">
											$<?php
												$today_date = date('Y-m-d');
												$sql = mysqli_query($con, "SELECT SUM(total_price) as total_today FROM orders where order_date = '$today_date'");
												$row = mysqli_fetch_array($sql);
												if($row['total_today'] == ''){
													echo '0';
												}else{
													//echo number_format($row['total_today'],2);
													$total_fq = number_format($row['total_today'],2);
													echo preg_replace("/\.?0+$/", "", $total_fq); 
												} 
											?>
										</h2>
									</div>
                                </div><br>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-12">
                        <!-- card -->
                        <div class="card card-inverse card-success">
                            <div class="card-body">
                                <div class="d-flex">
                                    <div class="m-r-20 align-self-center">
                                        <h1 class="text-white"><i class="ti-pie-chart"></i></h1></div>
                                    <div>
                                        <h3 class="card-title">Monthly Sales</h3>
                                        <h6 class="card-subtitle text-white"><?php echo date('M');?> <?php echo date('Y');?></h6> </div>
                                </div>
                                <div class="row">
                                    <div class="col-12 p-t-10 p-b-20 align-self-center">
                                        <h2 class="font-light text-white">
											$<?php
												$today_date = date('Y-m-d');
												$month_start = date('Y-m-01');
												$sql = mysqli_query($con, "SELECT SUM(total_price) as total_month FROM orders where order_date >= '$month_start' and order_date <= '$today_date'");
												$row = mysqli_fetch_array($sql);
												if($row['total_month'] == ''){
													echo '0';
												}else{
													echo number_format($row['total_month'],2);
												} 
											?>
										</h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- card -->
                    </div>
                </div>
				
				<div class="card-group">
                    <!-- Column -->
                    <!-- Column -->
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <h2 class="m-b-0"><i class="mdi mdi-drawing-box text-success"></i></h2>
                                    <h3 class=""><?php echo mysqli_num_rows(mysqli_query($con, "SELECT order_id FROM orders WHERE order_complete=0"))?></h3>
                                    <h6 class="card-subtitle">Active Orders</h6></div>
                                <div class="col-12">
                                    <div class="progress">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: 10%; height: 6px;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Column -->
                    <!-- Column -->
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <h2 class="m-b-0"><i class="mdi mdi-check-all text-success"></i></h2>
                                    <h3 class="">
										<?php 
											$com_orders = number_format(mysqli_num_rows(mysqli_query($con, "SELECT order_id FROM orders WHERE order_complete=1")),2);
											echo preg_replace("/\.?0+$/", "", $com_orders); 
										?>
									</h3>
                                    <h6 class="card-subtitle">Completed Orders</h6></div>
                                <div class="col-12">
                                    <div class="progress">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: 85%; height: 6px;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Column -->
                    <!-- Column -->
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <h2 class="m-b-0"><i class="mdi mdi-widgets text-success"></i></h2>
                                    <h3 class=""><?php echo mysqli_num_rows(mysqli_query($con, "SELECT product_id FROM product"))?></h3>
                                    <h6 class="card-subtitle">Total Products</h6></div>
                                <div class="col-12">
                                    <div class="progress">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: 100%; height: 6px;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
				<div class="row">
					<div class="col-md-12">
						<div class="card">
							<div class="card-body">
								<?php
							$current_year = date('Y');
							$current_month = date('m');
							$data_array = array();
							for($i = 1; $i <= $current_month; $i++){
								$start_date = date($current_year.'-0'.$i.'-'.'01');
								$end_date = date('Y-m-t', strtotime($start_date));
								$month_name = date('M-y',strtotime($start_date));
								$get_sales_data =  mysqli_query($con, "SELECT SUM(total_price) as total_month FROM orders where order_date >= '$start_date' and order_date <= '$end_date'");
								$sales_data = mysqli_fetch_array($get_sales_data);
								if($sales_data['total_month'] == ''){
									$total_sales = 0;
								}else{
									$total_sales = $sales_data['total_month'];
								}
								$data_array []= array('y' => $total_sales, 'label' => $month_name);
							}
							$dataPoints = array( 
								array("y" => 3373.64, "label" => "Germany" ),
								array("y" => 2435.94, "label" => "France" ),
								array("y" => 1842.55, "label" => "China" ),
								array("y" => 1828.55, "label" => "Russia" ),
								array("y" => 1039.99, "label" => "Switzerland" ),
								array("y" => 765.215, "label" => "Japan" ),
								array("y" => 612.453, "label" => "Netherlands" )
							);
							 
							?>
							<script>
								window.onload = function() {
								 
								var chart = new CanvasJS.Chart("chartContainer", {
									animationEnabled: true,
									theme: "light4",
									title:{
										text: "Monthly Sales"
									},
									axisY: {
										title: "Monthly Sales in Dollars ($)"
									},
									data: [{
										type: "column",
										yValueFormatString: "$#,##0.##",
										dataPoints: <?php echo json_encode($data_array, JSON_NUMERIC_CHECK); ?>
									}]
								});
								chart.render();
								 
								}
							</script>
								<div id="chartContainer" style="height: 420px; width: 100%;"></div>
								<script src="js/canvajs.js"></script>
							</div>
						</div>
						
					</div>
					
					<div class="col-md-5 d-none">
						<div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Top 3 Trending Products</h4>
                                <h6 class="card-subtitle">Most Earnings Products</h6> </div>
                            <!-- ============================================================== -->
                            <!-- Comment widgets -->
                            <!-- ============================================================== -->
							<?php 
								$color_array = array('green_block','blue_block','red_block');
								$count = 0;
								$get_top_products = mysqli_query($con,"SELECT p.product_id, p.product_title, p.product_price, p.product_image, COUNT(DISTINCT d.order_id) AS total_orders FROM order_details d JOIN orders o ON d.order_id = o.order_id JOIN product p ON d.product_id = p.product_id GROUP BY p.product_id, p.product_title, p.product_price ORDER BY total_orders DESC LIMIT 3;");
								while($top_row = mysqli_fetch_array($get_top_products)){
							?>
                            <div class="comment-widgets mb-0">
                                <!-- Comment Row -->
                                <div class="d-flex flex-row comment-row" style="background:azure !important">
                                    <div class="p-2"><span class="round"><img src="../images/product_images/<?php echo $top_row['product_image']?>" alt="user" width="50"></span></div>
                                    <div class="comment-text w-100">
                                        <h5><?php echo $top_row['product_title'];?></h5>
                                        <div class="comment-footer">
                                            <span class="label label-info">
												Orders: <?php echo $top_row['total_orders'];?>
											</span>
                                            <span class="label label-success">
												Earnings: <?php echo '$'.$top_row['product_price'] * $top_row['total_orders'];?>
											</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
							<?php $count++;} ?>
                        </div>
					</div>
					
				</div>
				<br>
			<?php } ?>				
            </div> 
			
			<?php include "includes/footer.php";?>
        </div>
        <!-- ============================================================== -->
        <!-- End Page wrapper  -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <?php include "includes/footerlinks.php";?>
</body>

</html>