<?php session_start(); ?>
<?php 
	include "database.php";
	include "includes/operations.php";
	if(!isset($_SESSION['admin_id'])){
		echo '<script> window.location.href = "login.php"; </script>';
		header("location:login.php"); exit();
	}
	
	function CheckAccess() {
		
    $result = (isset($_SESSION['role']) &&  $_SESSION['role'] != 'Super Admin');
		return $result;
	}
	
	if (CheckAccess()) {
		header("location:login.php");
			echo '<script> window.location.href = "login.php"; </script>';
			exit();
	}
	
	$admin_id = $_SESSION['admin_id'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php include "includes/headerlinks.php";?>
	<style>
		b {
			font-weight:600 !important;
		}
		.text-limit {
			overflow: hidden;
			width: 100%;
			display: -webkit-box;
			-webkit-line-clamp: 2;
			-webkit-box-orient: vertical;
		}
		.custom-image {
			height:100px;
			width:auto;/*maintain aspect ratio*/
			max-width:150px;
		}
	</style>
</head>

<body class="fix-header card-no-border">
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <?php include "includes/loader.php";?>
    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Topbar header - style you can find in pages.scss -->
        <!-- ============================================================== -->
        <?php include "includes/header.php";?>
        <!-- ============================================================== -->
        <!-- End Topbar header -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Left Sidebar - style you can find in sidebar.scss  -->
        <!-- ============================================================== -->
        <?php include "includes/sidebar.php";?>
        <!-- ============================================================== -->
        <!-- End Left Sidebar - style you can find in sidebar.scss  -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Page wrapper  -->
        <!-- ============================================================== -->
        <div class="page-wrapper">
            <!-- ============================================================== -->
            <!-- Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <div class="row page-titles">
                <div class="col-md-5 align-self-center">
                    <h3 class="text-themecolor">Manage Products </h3>
                </div>
            </div>
            <!-- ============================================================== -->
            <!-- End Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container">
                <!-- ============================================================== -->
                <!-- Start Page Content -->
                <!-- ============================================================== -->
                <!-- Row -->
				<div class="card">
                    <div class="card-body">
                        <h6 class="card-subtitle"><a href="add_product.php" class="btn btn-success">+ Add Product</a></h3></h6>
						<?php if (isset($_GET['error'])){
							echo '<p style="text-align:left; color:red"><b>Oops! Email already exists!</b></p>';
						}?>
						<div class="table-responsive m-t-10">
							<table id="myTable" class="table table-bordered table-striped">
								<thead>
								  <tr>
									<th>Image</th>
									<th>Name</th>
									<th>Description</th>
									<th>Action</th>
								  </tr>
								</thead>
								<tbody>
									<?php
										$result = mysqli_query($con,"SELECT * FROM product ORDER by product_id ASC");
										while($row=mysqli_fetch_array($result)){
									?>
									<tr>
										<td style="width:10%;"><img src="../images/product_images/<?php echo $row['product_image']?>" class="img-responsive img-thumbnail custom-image" width="100px" onerror="this.onerror=null;this.src='assets/images/null.png'"></td>
										<td style="width:20%;"><?php echo $row['product_title']; ?><br><small class="text-black">$<?php echo number_format($row['product_price'],2);?></small><br>
										<span class="label label-primary">
											<?php
												if($row['status']==1){
													echo 'Active';
												} else {
													echo 'Draft';
												}
											?>
										</span>
										</td>
										<td style="color:black; width:40%;">
											<p class="text-limit">
												<?php echo $row['product_description']?>
											</p>
										</td>
										<td style="width:20%;">
										<a href="details.php?pid=<?php echo $row['product_id']?>"><button class="btn btn-sm btn-warning"><i class="fa fa-eye"></i></button></a>
										<a href="edit_product.php?pid=<?php echo $row['product_id']?>"><button class="btn btn-sm btn-info"><i class="fa fa-edit"></i></button></a>
										<a data-toggle="modal" data-target="#delete<?=$row['product_id'];?>"><button class="btn btn-sm btn-danger"><i class="fa fa-trash-o"></i></button></a>
										</td>
										
										<div class="modal fade in" id="delete<?=$row['product_id'];?>"  role="dialog" aria-hidden="true">
										<div class="modal-dialog" role="document">
												<div class="modal-content">
												  <div class="modal-body">
													<h4>Are you sure you want to delete this ?</h4>
												  </div>
												  <div class="modal-footer">
													<form method="post">
														<input type="hidden" name="product_id" value="<?=$row['product_id']?>">
														<input type="hidden" name="pdf_name" value="<?=$row['pdf_name']?>">
														<button type="submit" class="btn btn-danger" name="delete_product" >Delete</button>
														<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
													</form>
												  </div>
												</div>
											  </div>
										</div>
									</tr>
									<?php
										}
									  ?>
								</tbody>
							</table>
						</div>
                    </div>
                </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- footer -->
            <!-- ============================================================== -->
            <?php include "includes/footer.php";?>
            <?php include "includes/theme.php";?>
            <!-- ============================================================== -->
            <!-- End footer -->
            <!-- ============================================================== -->
        </div>
		
        <!-- ============================================================== -->
        <!-- End Page wrapper  -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
	
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/bootstrap/js/popper.min.js"></script>

    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="js/custom.min.js"></script>
    <!-- ============================================================== -->
    <!-- Style switcher -->
    <!-- ============================================================== -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
</body>
   <script src="assets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script>
    $(document).ready(function() {
        $('#myTable').DataTable();
        $(document).ready(function() {
            var table = $('#example').DataTable({
                "columnDefs": [{
                    "visible": false,
                    "targets": 2
                }],
                "order": [
                    [2, 'asc']
                ],
                //"displayLength": 5,
				"pageLength": 5,
                "drawCallback": function(settings) {
                    var api = this.api();
                    var rows = api.rows({
                        page: 'current'
                    }).nodes();
                    var last = null;
                    api.column(2, {
                        page: 'current'
                    }).data().each(function(group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                            last = group;
                        }
                    });
                }
            });
            // Order by the grouping
            $('#example tbody').on('click', 'tr.group', function() {
                var currentOrder = table.order()[0];
                if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                    table.order([2, 'desc']).draw();
                } else {
                    table.order([2, 'asc']).draw();
                }
            });
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
</html>
