<!DOCTYPE html><html lang="en">
<head>
	<?php include "includes/operations.php";?>
	<?php include "includes/headerlinks.php";?>
	<?php 
		$get_cart_items = mysqli_query($con,"select cart.*,p.* from cart inner join product p on cart.prod_id = p.product_id where cust_ip = '$ipaddress' and date_added = '$date_added'");
		$total_items = mysqli_num_rows($get_cart_items);
		if($total_items <= 0){
			header('location:index.php');
		}
	?>
	
	<style>
	.value-minus,
		.value-plus{
			width: 3.5rem;
			height: 3.5rem;
			font-size: 15px !important;
			line-height: 3.3rem;
			margin-right: 3px;
			display: inline-block;
			cursor: pointer;
			position: relative;
			color: #fff;
			text-align: center;
			-webkit-user-select: none;
			-moz-user-select: none;
			border:1px solid #ebebeb;
			vertical-align: bottom;
			background:#ebebeb !important;
		}
		.quantity-select .entry.value-minus:before,
		.quantity-select .entry.value-plus:before{
			content: ""; 
			width: 13px;
			height: 2px; 
			background: #000;
			left: 50%;
			margin-left: -7px; 
			top: 50%;
			margin-top: -0.5px;
			position: absolute;
		}
		.quantity-select .entry.value-plus:after{
			content: "";
			height: 13px;
			width: 2px; 
			background: #000;
			left: 50%; 
			margin-left: -1.4px;
			top: 50%;
			margin-top: -6.2px;
			position: absolute;
		}
		.value  {
			cursor: default;
			width: 3.5rem;
			height: 3.5rem;
			font-size: 15px !important;
			line-height: 3.3rem;
			padding: 8px 0px;
			color: #000;
			line-height: 24px;
			border: 1px solid #E5E5E5;
			background-color: #E5E5E5;
			text-align: center;
			display: inline-block;
			margin-right: 3px;
		}
		.quantity-select .entry.value-minus:hover,
		 .quantity-select .entry.value-plus:hover{
			background: #E5E5E5;
		}

		.quantity-select .entry.value-minus{
			margin-left: 0;
		}
		
		.value-minus {
			border-radius: 17px 0 0 17px;
			margin-right: -5px;
		}
		.value-plus {
			border-radius:0 13px 13px 0;
			margin-left:-8px;
		}
		.bg-value {
			background:white !important;
		}
		
		.cart__table--body__list {
			//width:45% !important;
		}
		
		
		@media only screen and (max-width: 600px) {
			.quantity {
				position: relative !important;
				left: 34% !important;
				margin-top: 20px !important
			}
			.cart__table--body__list  {
				//padding:1rem 0 !important;
			}
		}
	</style>
	
</head>

<body>

    
		
	<?php include "includes/top_header.php";?>
	<?php include "includes/navigation.php";?>
	<?php include "includes/mobile_navigation.php";?>
	<?php include "includes/mobile_sticky_menus.php";?>
	<?php include "includes/cart_window.php";?>
	<?php include "includes/search.php";?>


    <main class="main__content_wrapper">
        <!-- Start slider section -->
        <section class="breadcrumb__section breadcrumb__bg">
            <div class="container-fluid">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content">
                            <h1 class="breadcrumb__content--title text-white mb-10">Shopping Cart</h1>
                            <ul class="breadcrumb__content--menu d-flex">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white">Shopping Cart</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End slider section -->

		<section class="cart__section section--padding">
            <div class="container-fluid">
                <div class="cart__section--inner">
                    <form action="includes/cart_operations.php" method="post"> 
                        <h2 class="cart__title mb-40">Shopping Cart</h2>
                        <div class="row">
                            <div class="col-lg-9">
                                <div class="cart__table">
                                    <table class="cart__table--inner">
                                        <thead class="cart__table--header">
                                            <tr class="cart__table--header__items">
                                                <th class="cart__table--header__list">Product</th>
                                                <th class="cart__table--header__list">Price</th>
                                                <th class="cart__table--header__list">Quantity</th>
                                                <th class="cart__table--header__list">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="cart__table--body">
											<?php
											$count = 0;
											$get_cart_items = mysqli_query($con,"select cart.*,p.* from cart inner join product p on cart.prod_id = p.product_id where cust_ip = '$ip_address' and date_added = '$date_added'");
											$total_items = mysqli_num_rows($get_cart_items);
											$total_price = 0;
											while($cart_items = mysqli_fetch_array($get_cart_items)){
												$count++;
												$total_price += $cart_items['product_price']*$cart_items['quantity'];
												$cart_quantity = $cart_items['quantity'];
												$product_price = $cart_items['product_price'];
											?>
                                            <tr class="cart__table--body__items cart_row_<?php echo $cart_items['product_id'];?>">
                                                <td class="cart__table--body__list">
                                                    <div class="cart__product d-flex align-items-center">
                                                        <button class="cart__remove--btn remove_cart_item" total_price="<?php echo $cart_items['product_price']*$cart_items['quantity'];?>" id="remove_cart_item_<?php echo $cart_items['product_id'];?>" aria-label="search button" type="button"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="16px" height="16px"><path d="M 4.7070312 3.2929688 L 3.2929688 4.7070312 L 10.585938 12 L 3.2929688 19.292969 L 4.7070312 20.707031 L 12 13.414062 L 19.292969 20.707031 L 20.707031 19.292969 L 13.414062 12 L 20.707031 4.7070312 L 19.292969 3.2929688 L 12 10.585938 L 4.7070312 3.2929688 z"></path></svg></button>
                                                        <div class="cart__thumbnail">
                                                            <a href="product-details.php?id=<?php echo $cart_items['product_id'];?>"><img class="border-radius-5" src="images/product_images/<?php echo $cart_items['product_image'];?>" alt="cart-product"></a>
                                                        </div>
                                                        <div class="cart__content">
                                                            <h4 class="cart__content--title"><a href="product-details.php?id=<?php echo $cart_items['product_id'];?>"><?php echo $cart_items['product_title'];?></a></h4>
                                                        </div>
                                                    </div>
                                                </td>
												<td class="invert cart__price cart__table--body__list">$<?php echo number_format($cart_items['product_price'],2);?></td>
												<td class="invert">
													<div class="quantity"> 
														<div class="quantity-select">
															<div class="entry value-minus" entry-num="<?php echo $count ?>" cart-id="<?php echo $cart_items['id'] ?>">&nbsp;</div>
															<div class="entry value bg-value"><span><?php echo $cart_quantity ?></span></div>
															<div class="entry value-plus active" entry-num="<?php echo $count ?>" cart-id="<?php echo $cart_items['id'] ?>">&nbsp;</div>
															<div class="product_price" style="display:none;"><span><?php echo $product_price ?></span></div>
														</div>
													</div>
												</td>
												<td class="invert cart__table--body__list">$<span id="total_price_<?php echo $count; ?>"><?php echo $product_price * $cart_quantity ?></span>.00</td>
                                            </tr>
											<?php }?>
											<?php 
											if($total_items <= 0){
											?>
											<tr class="cart__table--body__items">
                                                <td class="cart__table--body__list" colspan="4" style="text-align:center">
													<p>No items in the cart</p>
												</td>
											</tr>
											<?php }?>
                                        </tbody>
                                    </table> 
                                    <div class="continue__shopping d-flex justify-content-between">
										<?php 
											if($total_items > 0){
										?>
                                        <a class="continue__shopping--link" href="index.php">Continue shopping</a>
                                        <button class="continue__shopping--clear" type="submit" name="del_cart">Clear Cart</button>
										<?php 
											}
										?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="cart__summary border-radius-10">
                                   <div class="cart__note mb-20">
                                        <h3 class="cart__note--title" style="border-bottom: 1px solid #e4e4e4;">Cart Totals</h3>
                                    </div>
                                    <div class="cart__summary--total mb-20" style="border-bottom: 1px solid #e4e4e4;">
                                        <table class="cart__summary--total__table">
                                            <tbody>
												<?php
													$total_price_final = 0;
													$presult = mysqli_query($con,"select cart.*,p.* from cart inner join product p on cart.prod_id = p.product_id where cust_ip = '$ip_address' and date_added = '$date_added'");

													while ($prow = mysqli_fetch_array($presult)) {
														$total_price_final = $total_price_final + ($prow['product_price']*$prow['quantity']);
													}
												?>
												<tr class="checkout__total--footer__items">
													<td class="checkout__total--footer__title checkout__total--footer__list text-left" style="padding-top:0px !important">Total </td>
													<td class="checkout__total--footer__amount checkout__total--footer__list text-right" style="padding-top:0px !important"><span>$<span id="total_price_table"><?php echo $total_price_final; ?></span></span></td>
												</tr>
                                            </tbody>
                                        </table>
                                    </div>
									<?php 
										if($total_items > 0){
									?>
									<?php
										$fresult = mysqli_query($con,"select cart.*,p.* from cart inner join product p on cart.prod_id = p.product_id where cust_ip = '$ip_address' and date_added = '$date_added'");
										$cout = 0;
										while ($frow = mysqli_fetch_array($fresult)) {
											$cout++;
									?>
										<input type="hidden" id="frow_quantity_<?php echo $cout ?>" value="<?php echo $frow['cart_quantity'] ?>">
										<input type="hidden" class="frow_price" id="frow_price_<?php echo $cout ?>" value="<?php echo ($frow['product_price']*$frow['quantity']); ?>">
									<?php
										}
									?>
									<p class="cart__summary--footer__desc">Shipping &amp; taxes calculated at checkout</p>
									<p><b style="color:red"><i>We only ship within the USA*</b></i></p>
									
                                    <div class="cart__summary--footer">
                                        <center><a class="cart__summary--footer__btn primary__btn checkout" href="checkout.php">CHECKOUT</a></center>
                                    </div>
										<?php }?>
                                </div> 
                            </div>
                        </div> 
                    </form> 
                </div>
            </div>     
        </section>
	</main>

    <!-- Start footer section -->
    <?php include "includes/footer.php";?>
    <!-- End footer section -->

    <!-- Quickview Wrapper -->
    <div class="modal" id="modal1" data-animation="slideInUp">
        <div class="modal-dialog quickview__main--wrapper">
           <header class="modal-header quickview__header">
                <button class="close-modal quickview__close--btn" aria-label="close modal" data-close="">✕ </button>
            </header>
           <div class="quickview__inner">
                <div class="row row-cols-lg-2 row-cols-md-2">
                    <div class="col">
                        <div class="product__details--media">
                            <div class="product__media--preview  swiper">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <div class="product__media--preview__items">
                                            <a class="product__media--preview__items--link glightbox" data-gallery="product-media-preview" href="images/big-product1.webp"><img class="product__media--preview__items--img" src="images/big-product1.webp" alt="product-media-img"></a>
                                            <div class="product__media--view__icon">
                                                <a class="product__media--view__icon--link glightbox" href="images/big-product1.webp" data-gallery="product-media-preview">
                                                    <svg class="product__media--view__icon--svg" xmlns="http://www.w3.org/2000/svg" width="22.51" height="22.443" viewBox="0 0 512 512"><path d="M221.09 64a157.09 157.09 0 10157.09 157.09A157.1 157.1 0 00221.09 64z" fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32"></path><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-miterlimit="10" stroke-width="32" d="M338.29 338.29L448 448"></path></svg>
                                                    <span class="visually-hidden">Media Gallery</span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="product__media--nav swiper">
                                <div class="swiper__nav--btn swiper-button-next"></div>
                                <div class="swiper__nav--btn swiper-button-prev"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="quickview__info">
                            <form action="#">
                                <h2 class="product__details--info__title mb-15">Oversize Cotton Dress</h2>
                                <div class="product__details--info__price mb-12">
                                    <span class="current__price">$58.00</span>
                                </div>
                                <p class="product__details--info__desc mb-15">Lorem ipsum dolor sit amet, consectetur adipisicing elit is. Deserunt totam dolores ea numquam labore! Illum magnam totam tenetur fuga quo dolor.</p>
                                <div class="product__variant">
                                    <div class="quickview__variant--list quantity d-flex align-items-center mb-15">
                                        <div class="quantity__box">
                                            <button type="button" class="quantity__value quickview__value--quantity decrease" aria-label="quantity value" value="Decrease Value">-</button>
                                            <label>
                                                <input type="number" class="quantity__number quickview__value--number" value="1">
                                            </label>
                                            <button type="button" class="quantity__value quickview__value--quantity increase" aria-label="quantity value" value="Increase Value">+</button>
                                        </div>
                                        <button class="primary__btn quickview__cart--btn" type="submit">Add To Cart</button>  
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Quickview Wrapper End -->

	<?php include "includes/footerlinks.php";?>
	<?php include "includes/cart_functions.php";?>
	<script>
		function update_cart(cart_id, cart_quantity) {
			$.ajax({
				url : 'ajax.php',
				type : 'post',
				data : {
					'update_cart_quantity' : 1,
					'cart_id' : cart_id,
					'cart_quantity' : cart_quantity
				},
				success : function (res) {
					//alert(res);
					//response
				}
			});
		}
		
		function make_total() {
			var total_price_table = 0;
			$('.frow_price').each(function(){
				total_price_table += parseInt($(this).val());
			});
			$('#total_price_table').html(total_price_table);
		}
		$('.value-plus').on('click', function(){
			var divUpd = $(this).parent().find('.value'), newVal = parseInt(divUpd.text(), 10)+1;
			var product_price = parseInt($(this).parent().find('.product_price').text());
			divUpd.text(newVal);
			
			var entry_num = $(this).attr('entry-num');
			var cart_id = $(this).attr('cart-id');
			
			update_cart(cart_id, newVal);
			$('#total_price_'+entry_num).html(product_price*newVal);
			$('#list_product_total_'+entry_num).html(product_price*newVal);
			$('#frow_quantity_'+entry_num).val(newVal);
			$('#frow_price_'+entry_num).val(product_price*newVal);
			make_total();
		});

		$('.value-minus').on('click', function(){
			var divUpd = $(this).parent().find('.value'), newVal = parseInt(divUpd.text(), 10)-1;
			var product_price = parseInt($(this).parent().find('.product_price').text());
			
			var entry_num = $(this).attr('entry-num');
			var cart_id = $(this).attr('cart-id');
			if(newVal>=1) {
				divUpd.text(newVal);
				
				update_cart(cart_id, newVal);
				$('#total_price_'+entry_num).html(product_price*newVal);
				$('#list_product_total_'+entry_num).html(product_price*newVal);
				$('#frow_quantity_'+entry_num).val(newVal);
				$('#frow_price_'+entry_num).val(product_price*newVal);
				make_total();
			}
		});
		</script>

</body></html>