<!DOCTYPE html>
<html lang="en">
<head>
	<?php
		include "includes/operations.php";
		include "includes/headerlinks.php";
	?>
	<?php
		
		$order_number = 0;
		if (isset($_GET['id'])) {
			$order_number = intval($_GET['id']);
		}
		
		$order_result = mysqli_query($con, "SELECT * FROM orders WHERE order_id=$order_number");
		if (mysqli_num_rows($order_result)==0) {
			header("Location:404.php");
			exit();
		}
		
		$order_row = mysqli_fetch_array($order_result);
		$order_id = $order_row['id'];
		
	?>
	<style>
		.logo-setting-one {
			max-width: 25% !important;
		}
		@media only screen and (max-width: 600px) {
			.logo-setting-one {
				max-width: 40% !important;
			}
			.an {
				width: 50% !important;
			}
		}
	</style>
</head>

<body>

    
		
	<?php include "includes/top_header.php";?>
	<?php include "includes/navigation.php";?>
	<?php include "includes/mobile_navigation.php";?>
	<?php include "includes/mobile_sticky_menus.php";?>
	<?php include "includes/cart_window.php";?>
	<?php include "includes/search.php";?>


    <main class="main__content_wrapper">
        <!-- Start slider section -->
        
		<section class="breadcrumb__section breadcrumb__bg">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content">
                            <h1 class="breadcrumb__content--title text-white mb-10">Tracking Order</h1>
                            <ul class="breadcrumb__content--menu d-flex">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white">Tracking Order</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
		
		<section class="contact__section section--padding">
            <div class="container">
				<div class="blog__section--inner p-0">
					<div class="row row-cols-lg-4 row-cols-md-2 row-cols-sm-2 row-cols-1 mb--n30">
						<div class="col-lg-6 col-md-6">
							<div class="contact__form">
								<?php if($order_row['order_complete']==1){?>
								<center>
									<label class="checkout__checkbox--label" for="check2" style="padding-left:0px !important;">
										Order Number: <b><?=$order_number;?></b>
									</label><br>
									<label class="checkout__checkbox--label" for="check2" style="padding-left:0px !important;">
										<h3>Delivered</h3>
										
									</label>
									<img class="error__content--img error-404 mb-10 logo-setting-one" src="images/delivery-truck.jpg" alt="error-img"><br>
									<label class="checkout__checkbox--label" style="padding-left:0px !important;" for="check2">
										This is just a quick update to let you know that your order is now in the mail and on its way to you.
									</label>
								</center>
								<?php } else { ?>
								<center>
									<label class="checkout__checkbox--label" for="check2" style="padding-left:0px !important;">
										Order Number: <b><?=$order_number;?></b>
									</label><br>
									<label class="checkout__checkbox--label" for="check2" style="padding-left:0px !important;">
										<h3 class="mb-10">Pending</h3>
									</label>
									<img class="error__content--img error-404 logo-setting-one an mb-10" src="images/pending.webp" alt="error-img"><br>
									<label class="checkout__checkbox--label" style="padding-left:0px !important;" for="check2">
										Your shipment will go out within 5 business days. You’ll receive an email confirmation once shipped.
									</label>
								</center>
								<?php } ?>
							</div>
						</div>
						<div class="col-lg-6 col-md-6">
							<aside class="checkout__sidebar sidebar border-radius-10">
								<h2 class="checkout__order--summary__title text-center mb-15">Your Order Summary</h2>
								<?php
									$result = mysqli_query($con, "SELECT * FROM order_details INNER JOIN product ON order_details.product_id = product.product_id WHERE order_id=$order_id");
							
								?>
								<?php if (mysqli_num_rows($result)>0) { ?>
								<div class="cart__table checkout__product--table">
									<table class="cart__table--inner">
										<tbody class="cart__table--body">
											<?php
												$total_price = 0;
												$count = 0;
												while ($row = mysqli_fetch_array($result)) {
												$total_price = $total_price + ($row['product_price']*$row['product_quantity']);
												$count++;
												$pid = $row['product_id'];
														
											?>
											<tr class="cart__table--body__items">
												<td class="cart__table--body__list">
													<div class="product__image two  d-flex align-items-center">
														<div class="product__thumbnail border-radius-5">
															<a class="display-block" href="#"><img class="display-block border-radius-5" src="images/product_images/<?php echo $row['product_image']?>" alt="cart-product"></a>
															<span class="product__thumbnail--quantity">
																<?php echo $row['product_quantity'];?>
															</span>
														</div>
														<div class="product__description">
															<h4 class="product__description--name" style="max-width: 220px !important;">
																<a href="#">
																	<?php echo $row['product_title']?>
																</a>
															</h4>
														</div>
													</div>
												</td>
												<td class="cart__table--body__list">
													<span class="cart__price">$<?php echo $row['product_price']*$row['product_quantity'] ?>.00</span>
												</td>
											</tr>
											<?php
												}
											?>
										</tbody>
									</table> 
								</div>
								<div class="checkout__total" style="border-top:0px !important;">
									<table class="checkout__total--table">
										<tr class="checkout__total--items">
											<td class="checkout__total--title text-left">Subtotal</td>
											<td class="checkout__total--calculated__text text-right">
												$<?php echo number_format($total_price,2);?>
											</td>
										</tr>
										<tr class="checkout__total--items">
											<td class="checkout__total--title text-left">Estimated Tax (7%)</td>
											<td class="checkout__total--calculated__text text-right">
												$<?php
													$tax = 7/100;
													echo $value_tax = $total_price * $tax;
												?>
											</td>
										</tr>
										<tr class="checkout__total--items">
											<td class="checkout__total--title text-left">Shipping Cost</td>
											<td class="checkout__total--calculated__text text-right">
												$9.95
											</td>
										</tr>
										<tr>
											<td colspan="3"><hr style="border:1px solid #e4e4e4" /></td>
										</tr>
										<?php
											$shipping_cost = floatval(9.95);
											$final_total = $total_price + $shipping_cost + $value_tax;
										?>
										<tfoot class="checkout__total--footer">
											<tr class="checkout__total--footer__items">
												<td class="checkout__total--footer__title checkout__total--footer__list text-left">Total </td>
												<td class="checkout__total--footer__amount checkout__total--footer__list text-right">$<span id="grand_total"><?php echo number_format($final_total,2);?></span></td>
												
											</tr>
										</tfoot>
									</table>
								</div>
								<div class="payment__history mb-30">
								</div>
								<?php } else { ?>
								<div class="checkout-right">
									<h4 class="text-left" style="color:red !important">Your shopping cart don't contain any Product</span></h4>
								</div>
								<?php } ?>
							</aside>
						</div>
					</div>
				</div>
			</div>
        </section>

    </main>

    <!-- Start footer section -->
    <?php include "includes/footer.php";?>
    <!-- End footer section -->

	<?php include "includes/footerlinks.php";?>

</body></html>